#include <algorithm>
#include <iostream>
#include <vector>
#include <utility>

#define CR const&

using namespace std;

vector<int> Prekidi(vector<int> CR niz) {
    vector<int> rezultat;
    for (int i = 1; i < niz.size(); ++i) {
        if (niz[i - 1] > niz[i]) {
            rezultat.push_back(i);
        }
    }
    return rezultat;
}
vector<bool> Otklonjivi(vector<int> CR niz, vector<int> CR prekidi) {
    vector<bool> rezultat(niz.size(), false);
    for (auto& p : prekidi) {
        rezultat[p] = niz[p - 1] <= niz[p + 1];
    }
    return rezultat;
}

pair<int, bool> Pretreaga(vector<int> CR niz, int v) {
    int l = 0;
    int r = niz.size() - 1;
    while (l <= r) {
        int m = (l + r) / 2;
        if (niz[m] == v) {
            return { m, true };
        }
        if (niz[m] < v) {
            l = m + 1;
            continue;
        }
        r = m - 1;
    }
    return { l, false };
}

bool DobarPoklon(vector<int> CR niz, vector<int> CR prekidi, vector<bool> CR otklonjiv, int l, int r) {
    auto levi = Pretreaga(prekidi, l);
    auto desni = Pretreaga(prekidi, r);
    if (levi.first == desni.first || (desni.first - levi.first == 1 && (levi.first == l || prekidi[levi.first] - l == 1))) {
        return true;
    }
    if (desni.first - levi.first == 1) {
        return otklonjiv[levi.first];
    }
    return false;
}

int main() {
    int n;
    cin >> n;
    vector<int> poklonGenerator(n);
    for (auto& i : poklonGenerator) {
        cin >> i;
    }
    vector<int> prekidi = Prekidi(poklonGenerator);
    vector<bool> otklonjiv = Otklonjivi(poklonGenerator, prekidi);
    for (auto& v : prekidi) {
        cout << v << ' ';
    }
    cout << endl;
    for (auto u : otklonjiv) {
        cout << u << ' ';
    }
    cout << endl;
    int q;
    int l;
    int r;
    cin >> q;
    while (q--) {
        cin >> l >> r;
        --l;
        --r;
        cout << (DobarPoklon(poklonGenerator, prekidi, otklonjiv, l, r) ? "DA" : "NE") << endl;
    }
    return 0;
}